/* TODO
 
 Cleanup mark class
 
 Fork / Split the project eventually?
 
 Mechincally move left/right/up/down to next mark - experiment with diagonals.
 
 rotate marks in 90 degree orientations if necessary
 
 *sequencing options*
 
 Use this bounding box to have points touch the edges of
 the screen by picking points that are on the end of the box.
 
 Use marks to influence other marks / parent / child relationships
 
 Have a hard drive that organizes and archives all the marks - include pressure in the mark making format if necessary.
 
 // add eraser / automatic?
 
 */

import java.util.Arrays;
import java.awt.Polygon;

mark currentMark;
mark playingMark;
mark[] marks;

PVector lastMouse;
PVector markEnd;

// add read marks

void setup() {

  size(displayWidth, displayHeight, P3D);
  //hint(DISABLE_OPENGL_2X_SMOOTH);
  frameRate(60);
  noSmooth();
  fill(255);
  stroke(255);
  noStroke();
  //strokeWeight(1.8);
  marks = new mark[0];
  markEnd = new PVector(width/2, height/2);
}

void draw() {

  background(0);

  if (playingMark != null) {
    playingMark.render();
  }

  if (currentMark != null && currentMark.record) {
    currentMark.record();
  }
}

void keyPressed() {
}

void mousePressed() {
  lastMouse = new PVector(mouseX, mouseY);
  currentMark = new mark();
  currentMark.record=true;
}

void mouseReleased() {
  currentMark.record=false;
  marks = (mark[]) append(marks, currentMark);
  //currentMark.saveAll();
  currentMark.createPolygon();
  currentMark.saveMark("test");
  if (playingMark == null) playingMark = currentMark;
}

class mark {

  int[][] points;
  int i = 0;
  boolean record = false;
  int countedFrames = 0;
  int skippedFrames = 0;
  Polygon poly;

  mark() {
    points = new int[0][0];
  }

  void record() { // allow for pauses? or skip makrs with only 1 length
    int[] numbers = { 
      mouseX-int(lastMouse.x), mouseY-int(lastMouse.y), 0
    };
    if (points.length > 0 && !Arrays.equals(points[points.length-1], numbers)) {
      points[points.length-1][2] = skippedFrames;
      points = (int[][]) append(points, numbers);
      skippedFrames = 0;
    } 
    else if (points.length == 0) {
      points = (int[][]) append(points, numbers);
    }
    else skippedFrames++;
  }

  void createPolygon() {
    poly = new Polygon();
    for (int[] p : points) {
      poly.addPoint(p[0], p[1]);
    }
  }

  void render() {

    int size = points.length;

    if (size > 0) {
      int x = int(markEnd.x) + points[i][0];
      int y = int(markEnd.y) + points[i][1];

      //point(x, y);
      rect(x,y, 1, 1);

      if (points[i][2] == countedFrames) {
        countedFrames = 0;
        i++;
      } 
      else countedFrames++;

      if (i >= size) {
        i = 0;
        markEnd = new PVector(x, y);
        playingMark = getNextMark();
      }
    }
  }

  mark getNextMark() {
    mark newMark = marks[int(random(marks.length))];
    if (newMark == playingMark && marks.length > 1) {
      return getNextMark();
    }
    else if (checkMarkBounds(newMark) == false) {
      return getNextMark();
    } 
    else return newMark;
  }

  boolean checkMarkBounds(mark m) {
    for (int[] p : m.points) {
      int x = int(markEnd.x) + p[0];
      int y = int(markEnd.y) + p[1];
      if (x > width || x < 0) return false;
      if (y > height || y < 0) return false;
    }
    return true;
  }

  void saveMark(String name) {
    PrintWriter output = createWriter(name+".txt");
    int[] lastPoint = new int[0];
    int delayCounter = 0;
    String addString = "";
    for (int[] point : points) {
      if (Arrays.equals(lastPoint, point)) {
        delayCounter++;
      } 
      else {
        if (delayCounter > 0) output.print(","+(delayCounter+1)+"\n");
        else if (point != points[0]) addString = "\n";
        output.print(addString+point[0]+","+point[1]+","+point[2]);
        lastPoint = point;
        delayCounter = 0;
        addString = "";
      }
    }
    output.flush(); 
    output.close();
    //println(points.length);
  }

  //void saveAll() {
  //  PrintWriter output = createWriter("allmark.txt");
  //  for (int[] point : points) {
  //    output.println(point[0]+","+point[1]);
  //  }
  //  output.flush(); 
  //  output.close();
  // }
}

